/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui.quests;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ImageConfig;
import dev.ftb.mods.ftblibrary.config.ListConfig;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigFromStringScreen;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.BlankPanel;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ColorWidget;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.CursorType;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.VerticalSpaceWidget;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.CompactGridLayout;
import dev.ftb.mods.ftblibrary.util.ImageComponent;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.gui.ImageComponentWidget;
import dev.ftb.mods.ftbquests.gui.MultilineTextEditorScreen;
import dev.ftb.mods.ftbquests.gui.quests.AddRewardButton;
import dev.ftb.mods.ftbquests.gui.quests.AddTaskButton;
import dev.ftb.mods.ftbquests.gui.quests.DisabledButtonTextField;
import dev.ftb.mods.ftbquests.gui.quests.OpenInGuideButton;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.gui.quests.RewardButton;
import dev.ftb.mods.ftbquests.gui.quests.TaskButton;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.net.TogglePinnedMessage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestLink;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardAutoClaim;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.theme.QuestTheme;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public class ViewQuestPanel
extends Panel {
    public static final String PAGEBREAK_CODE = "{@pagebreak}";
    public static final Icon PAGEBREAK_ICON = Icon.getIcon((ResourceLocation)new ResourceLocation("ftbquests", "textures/gui/pagebreak.png"));
    public final QuestScreen questScreen;
    private Quest quest = null;
    public boolean hidePanel = false;
    private Icon icon = Color4I.EMPTY;
    public Button buttonClose;
    public Button buttonPin;
    public Button buttonOpenDependencies;
    public Button buttonOpenDependants;
    public BlankPanel panelContent;
    public BlankPanel panelTasks;
    public BlankPanel panelRewards;
    public BlankPanel panelText;
    private TextField titleField;
    private final List<Pair<Integer, Integer>> pageIndices = new ArrayList<Pair<Integer, Integer>>();
    private final Long2IntMap currentPages = new Long2IntOpenHashMap();
    private long lastScrollTime = 0L;

    public ViewQuestPanel(QuestScreen g) {
        super((Panel)g);
        this.questScreen = g;
        this.setPosAndSize(-1, -1, 0, 0);
        this.setOnlyRenderWidgetsInside(true);
        this.setOnlyInteractWithWidgetsInside(true);
    }

    public boolean viewingQuest() {
        return this.quest != null;
    }

    public boolean viewingQuest(Quest quest) {
        return this.quest == quest;
    }

    public Quest getViewedQuest() {
        return this.quest;
    }

    public boolean setViewedQuest(Quest newQuest) {
        if (this.quest != newQuest) {
            this.quest = newQuest;
            this.refreshWidgets();
            return true;
        }
        return false;
    }

    public boolean canEdit() {
        return this.quest.getQuestFile().canEdit();
    }

    private void buildPageIndices() {
        this.pageIndices.clear();
        if (this.quest != null) {
            int l1;
            for (int l2 = l1 = 0; l2 < this.quest.description.size(); ++l2) {
                if (!this.quest.description.get(l2).equals(PAGEBREAK_CODE)) continue;
                this.pageIndices.add((Pair<Integer, Integer>)Pair.of((Object)l1, (Object)(l2 - 1)));
                l1 = l2 + 1;
            }
            if (l1 < this.quest.description.size()) {
                this.pageIndices.add((Pair<Integer, Integer>)Pair.of((Object)l1, (Object)(this.quest.description.size() - 1)));
            }
        }
    }

    private int getCurrentPage() {
        if (this.quest == null) {
            return 0;
        }
        int page = this.currentPages.getOrDefault(this.quest.id, 0);
        if (page < 0 || page >= this.pageIndices.size()) {
            page = 0;
            this.currentPages.put(this.quest.id, 0);
        }
        return page;
    }

    private void setCurrentPage(int page) {
        if (this.quest != null) {
            this.currentPages.put(this.quest.id, page);
        }
    }

    public void addWidgets() {
        this.setPosAndSize(-1, -1, 1, 1);
        if (this.quest == null || this.hidePanel) {
            return;
        }
        QuestObjectBase prev = QuestTheme.currentObject;
        QuestTheme.currentObject = this.quest;
        this.setScrollX(0.0);
        this.setScrollY(0.0);
        this.icon = this.quest.getIcon();
        boolean canEdit = this.questScreen.file.canEdit();
        this.titleField = new QuestDescriptionField(this, canEdit, b -> this.editTitle()).addFlags(4).setMinWidth(150).setMaxWidth(500).setSpacing(9).setText((Component)this.quest.getTitle().m_6881_().m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)((Color4I)ThemeProperties.QUEST_VIEW_TITLE.get()).rgb()))));
        int w = Math.max(200, this.titleField.width + 54);
        if (this.quest.minWidth > 0) {
            w = Math.max(this.quest.minWidth, w);
        } else if (this.questScreen.selectedChapter.defaultMinWidth > 0) {
            w = Math.max(this.questScreen.selectedChapter.defaultMinWidth, w);
        }
        this.titleField.setPosAndSize(27, 4, w - 54, this.titleField.height);
        this.add((Widget)this.titleField);
        this.panelContent = new BlankPanel((Panel)this, "ContentPanel");
        this.add((Widget)this.panelContent);
        this.panelTasks = new BlankPanel((Panel)this.panelContent, "TasksPanel");
        this.panelContent.add((Widget)this.panelTasks);
        this.panelRewards = new BlankPanel((Panel)this.panelContent, "RewardsPanel");
        this.panelContent.add((Widget)this.panelRewards);
        this.panelText = new BlankPanel((Panel)this.panelContent, "TextPanel");
        this.panelContent.add((Widget)this.panelText);
        int bsize = 18;
        for (Task task : this.quest.tasks) {
            TaskButton b2 = new TaskButton((Panel)this.panelTasks, task);
            this.panelTasks.add((Widget)b2);
            b2.setSize(bsize, bsize);
        }
        if (!canEdit && this.panelTasks.widgets.isEmpty()) {
            Object noTasks = new DisabledButtonTextField((Panel)this.panelTasks, (Component)Component.m_237115_((String)"ftbquests.gui.no_tasks"));
            noTasks.setSize(((DisabledButtonTextField)((Object)noTasks)).width + 8, bsize);
            noTasks.setColor((Color4I)ThemeProperties.DISABLED_TEXT_COLOR.get(this.quest));
            this.panelTasks.add(noTasks);
        }
        for (Reward reward : this.quest.rewards) {
            if (!canEdit && (this.questScreen.file.self.isRewardBlocked(reward) || reward.getAutoClaimType() == RewardAutoClaim.INVISIBLE)) continue;
            RewardButton b2 = new RewardButton((Panel)this.panelRewards, reward);
            this.panelRewards.add((Widget)b2);
            b2.setSize(bsize, bsize);
        }
        if (!canEdit && this.panelRewards.widgets.isEmpty()) {
            DisabledButtonTextField noRewards = new DisabledButtonTextField((Panel)this.panelRewards, (Component)Component.m_237115_((String)"ftbquests.gui.no_rewards"));
            noRewards.setSize(noRewards.width + 8, bsize);
            noRewards.setColor((Color4I)ThemeProperties.DISABLED_TEXT_COLOR.get(this.quest));
            this.panelRewards.add((Widget)noRewards);
        }
        if (this.questScreen.file.canEdit()) {
            this.panelTasks.add((Widget)new AddTaskButton((Panel)this.panelTasks, this.quest));
            this.panelRewards.add((Widget)new AddRewardButton((Panel)this.panelRewards, this.quest));
        }
        int ww = 0;
        for (Widget widget2 : this.panelTasks.widgets) {
            ww = Math.max(ww, widget2.width);
        }
        for (Widget widget2 : this.panelRewards.widgets) {
            ww = Math.max(ww, widget2.width);
        }
        Color4I color4I = (Color4I)ThemeProperties.WIDGET_BORDER.get(this.questScreen.selectedChapter);
        ww = Mth.m_14045_((int)ww, (int)70, (int)140);
        w = Math.max(w, ww * 2 + 10);
        if ((Integer)ThemeProperties.FULL_SCREEN_QUEST.get(this.quest) == 1) {
            w = this.questScreen.width - 1;
        }
        if (w % 2 == 0) {
            ++w;
        }
        this.setWidth(w);
        this.panelContent.setPosAndSize(0, Math.max(16, this.titleField.height + 8), w, 0);
        int iconSize = Math.min(16, this.titleField.height + 2);
        this.buttonClose = new CloseViewQuestButton();
        this.add((Widget)this.buttonClose);
        this.buttonClose.setPosAndSize(w - iconSize - 2, 4, iconSize, iconSize);
        this.buttonPin = new PinViewQuestButton();
        this.add((Widget)this.buttonPin);
        this.buttonPin.setPosAndSize(w - iconSize * 2 - 4, 4, iconSize, iconSize);
        if (this.questScreen.selectedChapter.id != this.quest.chapter.id) {
            GotoLinkedQuestButton b3 = new GotoLinkedQuestButton();
            this.add((Widget)b3);
            b3.setPosAndSize(iconSize + 4, 0, iconSize, iconSize);
        }
        ArrayList<QuestLink> links = new ArrayList<QuestLink>();
        this.questScreen.file.chapterGroups.forEach(group -> group.chapters.forEach(chapter -> chapter.getQuestLinks().stream().filter(link -> chapter != this.questScreen.selectedChapter && link.linksTo(this.quest)).forEach(links::add)));
        ViewQuestLinksButton linksButton = new ViewQuestLinksButton(links);
        this.add((Widget)linksButton);
        linksButton.setPosAndSize(w - iconSize * 3 - 4, 0, iconSize, iconSize);
        if (!this.quest.hasDependencies()) {
            this.buttonOpenDependencies = new SimpleButton((Panel)this, (Component)Component.m_237115_((String)"ftbquests.gui.no_dependencies"), Icon.getIcon((String)"ftbquests:textures/gui/arrow_left.png").withTint(color4I), (widget, button) -> {});
            this.add((Widget)this.buttonOpenDependencies);
        } else {
            this.buttonOpenDependencies = new SimpleButton((Panel)this, (Component)Component.m_237115_((String)"ftbquests.gui.view_dependencies"), Icon.getIcon((String)"ftbquests:textures/gui/arrow_left.png").withTint((Color4I)ThemeProperties.QUEST_VIEW_TITLE.get()), (widget, button) -> this.showList(this.quest.getDependencies().toList(), true));
            this.add((Widget)this.buttonOpenDependencies);
        }
        if (this.quest.getDependants().isEmpty()) {
            this.buttonOpenDependants = new SimpleButton((Panel)this, (Component)Component.m_237115_((String)"ftbquests.gui.no_dependants"), Icon.getIcon((String)"ftbquests:textures/gui/arrow_right.png").withTint(color4I), (widget, button) -> {});
            this.add((Widget)this.buttonOpenDependants);
        } else {
            this.buttonOpenDependants = new SimpleButton((Panel)this, (Component)Component.m_237115_((String)"ftbquests.gui.view_dependants"), Icon.getIcon((String)"ftbquests:textures/gui/arrow_right.png").withTint((Color4I)ThemeProperties.QUEST_VIEW_TITLE.get()), (widget, button) -> this.showList(this.quest.getDependants(), false));
            this.add((Widget)this.buttonOpenDependants);
        }
        this.buttonOpenDependencies.setPosAndSize(0, this.panelContent.posY + 2, 13, 13);
        this.buttonOpenDependants.setPosAndSize(w - 13, this.panelContent.posY + 2, 13, 13);
        TextField textFieldTasks = new TextField((Panel)this.panelContent){

            public TextField resize(Theme theme) {
                return this;
            }
        };
        int w2 = w / 2;
        textFieldTasks.setPosAndSize(2, 2, w2 - 3, 13);
        textFieldTasks.setMaxWidth(w);
        textFieldTasks.addFlags(36);
        textFieldTasks.setText((Component)Component.m_237115_((String)"ftbquests.tasks"));
        textFieldTasks.setColor((Color4I)ThemeProperties.TASKS_TEXT_COLOR.get(this.quest));
        this.panelContent.add((Widget)textFieldTasks);
        TextField textFieldRewards = new TextField((Panel)this.panelContent){

            public TextField resize(Theme theme) {
                return this;
            }
        };
        textFieldRewards.setPosAndSize(w2 + 2, 2, w2 - 3, 13);
        textFieldRewards.setMaxWidth(w);
        textFieldRewards.addFlags(36);
        textFieldRewards.setText((Component)Component.m_237115_((String)"ftbquests.rewards"));
        textFieldRewards.setColor((Color4I)ThemeProperties.REWARDS_TEXT_COLOR.get(this.quest));
        this.panelContent.add((Widget)textFieldRewards);
        this.panelTasks.setPosAndSize(2, 16, w2 - 3, 0);
        this.panelRewards.setPosAndSize(w2 + 2, 16, w2 - 3, 0);
        int at = this.panelTasks.align((WidgetLayout)new CompactGridLayout(bsize + 2));
        int ar = this.panelRewards.align((WidgetLayout)new CompactGridLayout(bsize + 2));
        int h = Math.max(at, ar);
        this.panelTasks.setHeight(h);
        this.panelRewards.setHeight(h);
        int tox = (this.panelTasks.width - this.panelTasks.getContentWidth()) / 2;
        int rox = (this.panelRewards.width - this.panelRewards.getContentWidth()) / 2;
        int toy = (this.panelTasks.height - this.panelTasks.getContentHeight()) / 2;
        int roy = (this.panelRewards.height - this.panelRewards.getContentHeight()) / 2;
        for (Widget widget3 : this.panelTasks.widgets) {
            widget3.setX(widget3.posX + tox);
            widget3.setY(widget3.posY + toy);
        }
        for (Widget widget3 : this.panelRewards.widgets) {
            widget3.setX(widget3.posX + rox);
            widget3.setY(widget3.posY + roy);
        }
        this.panelText.setPosAndSize(3, 16 + h + 12, w - 6, 0);
        Component subtitle = this.quest.getSubtitle();
        if (subtitle.m_214077_() == ComponentContents.f_237124_ && canEdit) {
            subtitle = Component.m_237113_((String)"[No Subtitle]");
        }
        if (!subtitle.equals(Component.m_237119_())) {
            this.panelText.add((Widget)new QuestDescriptionField((Panel)this.panelText, canEdit, b -> this.editSubtitle()).addFlags(4).setMinWidth(this.panelText.width).setMaxWidth(this.panelText.width).setSpacing(9).setText((Component)Component.m_237113_((String)"").m_7220_(subtitle).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY})));
        }
        boolean showText = !this.quest.hideTextUntilComplete.get(false) || this.questScreen.file.self != null && this.questScreen.file.self.isCompleted(this.quest);
        this.buildPageIndices();
        if (showText && !this.pageIndices.isEmpty()) {
            this.addDescriptionText(canEdit, subtitle);
        }
        if (showText && !this.quest.guidePage.isEmpty()) {
            if (subtitle.m_214077_() != ComponentContents.f_237124_) {
                this.panelText.add((Widget)new VerticalSpaceWidget((Panel)this.panelText, 7));
            }
            this.panelText.add((Widget)new OpenInGuideButton((Panel)this.panelText, this.quest));
            this.panelText.add((Widget)new OpenInGuideButton((Panel)this.panelText, this.quest));
        }
        if (this.pageIndices.size() > 1 || canEdit) {
            this.addButtonBar(canEdit);
        }
        if (this.panelText.widgets.isEmpty()) {
            this.panelContent.add(new ColorWidget((Panel)this.panelContent, color4I, null).setPosAndSize(w2, 0, 1, h + 40));
            this.panelText.setHeight(0);
            this.setHeight(Math.min(this.panelContent.getContentHeight(), this.parent.height - 10));
        } else {
            this.panelContent.add(new ColorWidget((Panel)this.panelContent, color4I, null).setPosAndSize(w2, 0, 1, 16 + h + 6));
            this.panelContent.add(new ColorWidget((Panel)this.panelContent, color4I, null).setPosAndSize(1, 16 + h + 6, w - 2, 1));
            this.panelText.setHeight(this.panelText.align((WidgetLayout)new WidgetLayout.Vertical(0, 1, 2)));
            this.setHeight(Math.min(this.panelContent.getContentHeight() + this.titleField.height + 12, this.parent.height - 10));
        }
        if ((Integer)ThemeProperties.FULL_SCREEN_QUEST.get(this.quest) == 1) {
            this.height = this.questScreen.height;
        }
        this.setPos((this.parent.width - this.width) / 2, (this.parent.height - this.height) / 2);
        this.panelContent.setHeight(this.height - 17);
        QuestTheme.currentObject = prev;
    }

    private void addDescriptionText(boolean canEdit, Component subtitle) {
        Pair<Integer, Integer> pageSpan = this.pageIndices.get(this.getCurrentPage());
        if (subtitle.m_214077_() != ComponentContents.f_237124_) {
            this.panelText.add((Widget)new VerticalSpaceWidget((Panel)this.panelText, 7));
        }
        for (int i = ((Integer)pageSpan.getFirst()).intValue(); i <= (Integer)pageSpan.getSecond() && i < this.quest.getDescription().length; ++i) {
            Component component = this.quest.getDescription()[i];
            ImageComponent img = this.findImageComponent(component);
            if (img != null) {
                ImageComponentWidget c = new ImageComponentWidget(this, (Panel)this.panelText, img, i);
                if (c.component.fit) {
                    double scale = (double)this.panelText.width / (double)c.width;
                    c.setSize((int)((double)c.width * scale), (int)((double)c.height * scale));
                } else if (c.component.align == 1) {
                    c.setX((this.panelText.width - c.width) / 2);
                } else if (c.component.align == 2) {
                    c.setX(this.panelText.width - c.width);
                } else {
                    c.setX(0);
                }
                this.panelText.add((Widget)c);
                continue;
            }
            int line = i;
            TextField field = new QuestDescriptionField((Panel)this.panelText, canEdit, context -> this.editDescLine(line, (boolean)context, null)).setMaxWidth(this.panelText.width).setSpacing(9).setText(component);
            field.setWidth(this.panelText.width);
            this.panelText.add((Widget)field);
        }
    }

    private void addButtonBar(boolean canEdit) {
        this.panelText.add((Widget)new VerticalSpaceWidget((Panel)this.panelText, 3));
        BlankPanel buttonPanel = new BlankPanel((Panel)this.panelText);
        buttonPanel.setSize(this.panelText.width, 14);
        this.panelText.add((Widget)buttonPanel);
        final int currentPage = this.getCurrentPage();
        MutableComponent page = Component.m_237113_((String)(currentPage + 1 + "/" + this.pageIndices.size())).m_130940_(ChatFormatting.GRAY);
        int labelWidth = this.questScreen.getTheme().getStringWidth((FormattedText)page);
        if (currentPage > 0) {
            SimpleTextButton prevPage = new SimpleTextButton((Panel)buttonPanel, (Component)Component.m_237119_(), (Icon)ThemeProperties.LEFT_ARROW.get()){

                public void onClicked(MouseButton mouseButton) {
                    ViewQuestPanel.this.setCurrentPage(Math.max(0, currentPage - 1));
                    ViewQuestPanel.this.refreshWidgets();
                }

                public void addMouseOverText(TooltipList list) {
                    list.add((Component)Component.m_237113_((String)"[Page Up]").m_130940_(ChatFormatting.DARK_GRAY));
                    list.add((Component)Component.m_237113_((String)"[Mousewheel Up]").m_130940_(ChatFormatting.DARK_GRAY));
                }
            };
            prevPage.setX(this.panelText.width - 43 - labelWidth);
            prevPage.setSize(16, 14);
            buttonPanel.add((Widget)prevPage);
        }
        if (this.pageIndices.size() > 1) {
            TextField pageLabel = new TextField((Panel)buttonPanel);
            pageLabel.setText((Component)page);
            pageLabel.setPosAndSize(this.panelText.width - 24 - labelWidth, 3, 20, 14);
            buttonPanel.add((Widget)pageLabel);
        }
        if (currentPage < this.pageIndices.size() - 1) {
            SimpleTextButton nextPage = new SimpleTextButton((Panel)buttonPanel, (Component)Component.m_237119_(), (Icon)ThemeProperties.RIGHT_ARROW.get()){

                public void onClicked(MouseButton mouseButton) {
                    ViewQuestPanel.this.setCurrentPage(Math.min(ViewQuestPanel.this.pageIndices.size() + 1, currentPage + 1));
                    ViewQuestPanel.this.refreshWidgets();
                }

                public void addMouseOverText(TooltipList list) {
                    list.add((Component)Component.m_237113_((String)"[Page Down]").m_130940_(ChatFormatting.DARK_GRAY));
                    list.add((Component)Component.m_237113_((String)"[Mousewheel Down]").m_130940_(ChatFormatting.DARK_GRAY));
                }
            };
            nextPage.setSize(16, 14);
            nextPage.setX(this.panelText.width - 5 - nextPage.width);
            buttonPanel.add((Widget)nextPage);
        }
        if (canEdit) {
            SimpleTextButton edit = new SimpleTextButton((Panel)buttonPanel, (Component)Component.m_237115_((String)"ftbquests.gui.edit").m_130946_(" \u25bc"), (Icon)ThemeProperties.EDIT_ICON.get()){

                public void onClicked(MouseButton mouseButton) {
                    ViewQuestPanel.this.openEditButtonContextMenu();
                }
            };
            edit.setX((this.panelText.width - edit.width) / 2);
            edit.setHeight(14);
            buttonPanel.add((Widget)edit);
        }
    }

    private ImageComponent findImageComponent(Component c) {
        Iterator iterator = c.m_7360_().iterator();
        if (iterator.hasNext()) {
            Component c1 = (Component)iterator.next();
            ComponentContents componentContents = c1.m_214077_();
            if (componentContents instanceof ImageComponent) {
                ImageComponent img = (ImageComponent)componentContents;
                return img;
            }
            return this.findImageComponent(c1);
        }
        return null;
    }

    public void alignWidgets() {
    }

    public void tick() {
        super.tick();
        if (this.quest != null && this.quest.hasDependencies() && !this.questScreen.file.self.canStartTasks(this.quest) && this.buttonOpenDependencies != null) {
            float red = Mth.m_14031_((float)((float)(System.currentTimeMillis() % 1200L) * 0.0026179939f));
            Color4I col = Color4I.rgb((int)((int)(red * 127.0f + 63.0f)), (int)0, (int)0);
            this.buttonOpenDependencies.setIcon(Icon.getIcon((String)"ftbquests:textures/gui/arrow_left.png").withTint(col));
        }
    }

    private void showList(Collection<QuestObject> c, boolean dependencies) {
        int hidden = 0;
        ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
        if (dependencies && this.quest.minRequiredDependencies > 0) {
            contextMenu.add(new ContextMenuItem((Component)Component.m_237110_((String)"ftbquests.quest.min_required_header", (Object[])new Object[]{this.quest.minRequiredDependencies}).m_130940_(ChatFormatting.UNDERLINE), (Icon)Color4I.EMPTY, null).setEnabled(false));
        }
        for (QuestObject object : c) {
            if (this.questScreen.file.canEdit() || object.isVisible(this.questScreen.file.self)) {
                MutableComponent title = object.getMutableTitle();
                if (object.getQuestChapter() != null && object.getQuestChapter() != this.quest.getQuestChapter()) {
                    MutableComponent suffix = Component.m_237113_((String)" [").m_7220_(object.getQuestChapter().getTitle()).m_130946_("]").m_130940_(ChatFormatting.GRAY);
                    title.m_7220_((Component)suffix);
                }
                contextMenu.add(new ContextMenuItem((Component)title, (Icon)Color4I.EMPTY, () -> this.questScreen.open(object, true)));
                continue;
            }
            ++hidden;
        }
        if (hidden > 0) {
            MutableComponent prefix = hidden == c.size() ? Component.m_237119_() : Component.m_237113_((String)"+ ");
            contextMenu.add(new ContextMenuItem((Component)prefix.m_7220_((Component)Component.m_237110_((String)"ftbquests.quest.hidden_quests_footer", (Object[])new Object[]{hidden})), (Icon)Color4I.EMPTY, null).setEnabled(false));
        }
        this.getGui().openContextMenu(contextMenu);
    }

    public void keyReleased(Key key) {
        if (this.hidePanel || this.quest == null) {
            return;
        }
        if (this.questScreen.file.canEdit()) {
            if (key.is(83)) {
                this.editSubtitle();
            } else if (key.is(84)) {
                this.editTitle();
            } else if (key.is(68)) {
                this.editDescription();
            } else if (key.is(80)) {
                this.addPageBreak();
            } else if (key.is(76)) {
                this.editDescLine0(-1, null);
            } else if (key.is(73)) {
                this.editDescLine0(-1, new ImageComponent());
            }
        }
        if (key.is(266) || key.is(263)) {
            this.setCurrentPage(Math.max(0, this.getCurrentPage() - 1));
            this.refreshWidgets();
        } else if (key.is(267) || key.is(262)) {
            this.setCurrentPage(Math.min(this.pageIndices.size() - 1, this.getCurrentPage() + 1));
            this.refreshWidgets();
        }
    }

    private void editTitle() {
        StringConfig c = new StringConfig(null);
        QuestObject qo = this.quest;
        String titleKey = "ftbquests.title";
        for (Widget w : this.panelTasks.widgets) {
            TaskButton b;
            if (!(w instanceof TaskButton) || !(b = (TaskButton)w).isMouseOver()) continue;
            qo = b.task;
            titleKey = "ftbquests.task_title";
            break;
        }
        Quest qo1 = qo;
        EditConfigFromStringScreen.open((ConfigFromString)c, (Object)qo1.title, (Object)"", (Component)Component.m_237115_((String)titleKey), accepted -> {
            if (accepted) {
                qo1.title = (String)c.value;
                new EditObjectMessage(qo1).sendToServer();
            }
            this.openGui();
        });
    }

    private void editSubtitle() {
        StringConfig c = new StringConfig(null);
        EditConfigFromStringScreen.open((ConfigFromString)c, (Object)this.quest.subtitle, (Object)"", (Component)Component.m_237115_((String)"ftbquests.quest.subtitle"), accepted -> {
            if (accepted) {
                this.quest.subtitle = (String)c.value;
                new EditObjectMessage(this.quest).sendToServer();
            }
            this.openGui();
        });
    }

    private void editDescription() {
        ListConfig lc = new ListConfig((ConfigValue)new StringConfig());
        lc.value = this.quest.description;
        new MultilineTextEditorScreen((Component)Component.m_237115_((String)"ftbquests.gui.edit_description"), (ListConfig<String, StringConfig>)lc, accepted -> {
            if (accepted) {
                new EditObjectMessage(this.quest).sendToServer();
                this.refreshWidgets();
            }
            this.openGui();
        }).openGui();
    }

    private void openEditButtonContextMenu() {
        ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
        contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"ftbquests.title").m_7220_(ViewQuestPanel.hotkey("T")), Icons.NOTES, this::editTitle));
        contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"ftbquests.quest.subtitle").m_7220_(ViewQuestPanel.hotkey("S")), Icons.NOTES, this::editSubtitle));
        contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"ftbquests.quest.description").m_7220_(ViewQuestPanel.hotkey("D")), Icons.NOTES, this::editDescription));
        contextMenu.add(ContextMenuItem.SEPARATOR);
        contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"ftbquests.gui.line").m_7220_(ViewQuestPanel.hotkey("L")), Icons.NOTES, () -> this.editDescLine0(-1, null)));
        contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"ftbquests.gui.page_break").m_7220_(ViewQuestPanel.hotkey("P")), PAGEBREAK_ICON, this::addPageBreak));
        contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"ftbquests.gui.image").m_7220_(ViewQuestPanel.hotkey("I")), Icons.ART, () -> this.editDescLine0(-1, new ImageComponent())));
        this.getGui().openContextMenu(contextMenu);
    }

    private static Component hotkey(String key) {
        return Component.m_237113_((String)(" [" + key + "]")).m_130940_(ChatFormatting.DARK_GRAY);
    }

    private void addPageBreak() {
        this.appendToPage(this.quest.description, List.of(PAGEBREAK_CODE, "(new page placeholder text)"), this.getCurrentPage());
        new EditObjectMessage(this.quest).sendToServer();
        this.setCurrentPage(Math.min(this.pageIndices.size() - 1, this.getCurrentPage() + 1));
        this.refreshWidgets();
    }

    private void editDescLine0(int line, @Nullable Object type) {
        if (type instanceof ImageComponent) {
            this.editImage(line, (ImageComponent)type);
            return;
        }
        StringConfig c = new StringConfig(null);
        int l = line + 1;
        int s = this.quest.description.size();
        if (l == 0) {
            l = this.quest.description.size() + 1;
            ++s;
        }
        MutableComponent title = Component.m_237115_((String)"ftbquests.quest.description").m_130946_(String.format(": %d/%d", l, s));
        EditConfigFromStringScreen.open((ConfigFromString)c, (Object)(line == -1 ? "" : this.quest.description.get(line)), (Object)"", (Component)title, accepted -> {
            if (accepted) {
                if (line == -1) {
                    this.appendToPage(this.quest.description, List.of((String)c.value), this.getCurrentPage());
                } else {
                    this.quest.description.set(line, (String)c.value);
                }
                new EditObjectMessage(this.quest).sendToServer();
                this.refreshWidgets();
            }
            this.openGui();
        });
    }

    private void editImage(int line, ImageComponent component) {
        ConfigGroup group = new ConfigGroup("ftbquests");
        group.add("image", (ConfigValue)new ImageConfig(), (Object)component.image.toString(), v -> {
            component.image = Icon.getIcon((String)v);
        }, (Object)"");
        group.addInt("width", component.width, v -> {
            component.width = v;
        }, 0, 1, 1000);
        group.addInt("height", component.height, v -> {
            component.height = v;
        }, 0, 1, 1000);
        group.addInt("align", component.align, v -> {
            component.align = v;
        }, 0, 1, 2);
        group.addBool("fit", component.fit, v -> {
            component.fit = v;
        }, false);
        group.savedCallback = accepted -> {
            this.openGui();
            if (accepted) {
                if (line == -1) {
                    this.appendToPage(this.quest.description, List.of(component.toString()), this.getCurrentPage());
                } else {
                    this.quest.description.set(line, component.toString());
                }
                new EditObjectMessage(this.quest).sendToServer();
                this.refreshWidgets();
            }
        };
        new EditConfigScreen(group).openGui();
    }

    private void appendToPage(List<String> list, List<String> toAdd, int pageNumber) {
        if (this.pageIndices.isEmpty()) {
            list.addAll(toAdd);
            this.buildPageIndices();
        } else {
            int idx = (Integer)this.pageIndices.get(pageNumber).getSecond() + 1;
            for (String line : toAdd) {
                list.add(idx, line);
                ++idx;
            }
        }
    }

    public void editDescLine(int line, boolean context, @Nullable Object type) {
        if (context) {
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"selectServer.edit"), (Icon)ThemeProperties.EDIT_ICON.get(), () -> this.editDescLine0(line, type)));
            contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"selectServer.delete"), (Icon)ThemeProperties.DELETE_ICON.get(), () -> {
                this.quest.description.remove(line);
                new EditObjectMessage(this.quest).sendToServer();
                this.refreshWidgets();
            }));
            this.getGui().openContextMenu(contextMenu);
        } else {
            this.editDescLine0(line, type);
        }
    }

    public void draw(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
        if (this.quest != null && !this.hidePanel) {
            QuestObjectBase prev = QuestTheme.currentObject;
            QuestTheme.currentObject = this.quest;
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.0, 500.0);
            super.draw(matrixStack, theme, x, y, w, h);
            matrixStack.m_85849_();
            QuestTheme.currentObject = prev;
        }
    }

    public void drawBackground(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
        Color4I borderColor = (Color4I)ThemeProperties.QUEST_VIEW_BORDER.get();
        Color4I.DARK_GRAY.withAlpha(120).draw(matrixStack, this.questScreen.getX(), this.questScreen.getY(), this.questScreen.width, this.questScreen.height);
        Icon background = (Icon)ThemeProperties.QUEST_VIEW_BACKGROUND.get();
        background.draw(matrixStack, x, y, w, h);
        if (this.titleField != null && this.panelContent != null) {
            int iconSize = Math.min(16, this.titleField.height + 2);
            this.icon.draw(matrixStack, x + 4, y + 4, iconSize, iconSize);
            borderColor.draw(matrixStack, x + 1, this.panelContent.getY(), w - 2, 1);
        }
    }

    public boolean mousePressed(MouseButton button) {
        return super.mousePressed(button) || this.isMouseOver();
    }

    public boolean mouseScrolled(double scroll) {
        long now = System.currentTimeMillis();
        if (super.mouseScrolled(scroll)) {
            this.lastScrollTime = now;
            return true;
        }
        if (now - this.lastScrollTime > 500L) {
            if (scroll < 0.0 && this.getCurrentPage() < this.pageIndices.size() - 1) {
                this.setCurrentPage(this.getCurrentPage() + 1);
                this.refreshWidgets();
                this.lastScrollTime = now;
                return true;
            }
            if (scroll > 0.0 && this.getCurrentPage() > 0) {
                this.setCurrentPage(this.getCurrentPage() - 1);
                this.refreshWidgets();
                this.lastScrollTime = now;
                return true;
            }
        }
        return false;
    }

    private class QuestDescriptionField
    extends TextField {
        private final boolean canEdit;
        private final Consumer<Boolean> editCallback;

        QuestDescriptionField(Panel panel, boolean canEdit, Consumer<Boolean> editCallback) {
            super(panel);
            this.canEdit = canEdit;
            this.editCallback = editCallback;
        }

        public boolean mousePressed(MouseButton button) {
            if (this.isMouseOver()) {
                Style style;
                if (this.canEdit && button.isRight()) {
                    this.editCallback.accept(true);
                    return true;
                }
                if (button.isLeft() && Minecraft.m_91087_().f_91080_ != null && (style = this.getComponentStyleAt(ViewQuestPanel.this.questScreen.getTheme(), this.getMouseX(), this.getMouseY())) != null) {
                    return this.handleCustomClickEvent(style) || Minecraft.m_91087_().f_91080_.m_5561_(style);
                }
            }
            return super.mousePressed(button);
        }

        private boolean handleCustomClickEvent(Style style) {
            if (style == null) {
                return false;
            }
            ClickEvent clickEvent = style.m_131182_();
            if (clickEvent == null) {
                return false;
            }
            if (clickEvent.m_130622_() == ClickEvent.Action.CHANGE_PAGE) {
                try {
                    long questId = Long.valueOf(clickEvent.m_130623_(), 16);
                    QuestObject qo = FTBQuests.PROXY.getQuestFile(true).get(questId);
                    if (qo != null) {
                        ViewQuestPanel.this.questScreen.open(qo, false);
                    } else {
                        this.errorToPlayer("Unknown quest object id: %s", clickEvent.m_130623_());
                    }
                }
                catch (NumberFormatException e) {
                    this.errorToPlayer("Invalid quest object id: %s (%s)", clickEvent.m_130623_(), e.getMessage());
                }
                return true;
            }
            if (clickEvent.m_130622_() == ClickEvent.Action.OPEN_URL) {
                try {
                    URI uri = new URI(clickEvent.m_130623_());
                    String scheme = uri.getScheme();
                    if (scheme == null) {
                        throw new URISyntaxException(clickEvent.m_130623_(), "Missing protocol");
                    }
                    if (!scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
                        throw new URISyntaxException(clickEvent.m_130623_(), "Unsupported protocol: " + scheme.toLowerCase(Locale.ROOT));
                    }
                    Screen curScreen = Minecraft.m_91087_().f_91080_;
                    Minecraft.m_91087_().m_91152_((Screen)new ConfirmLinkScreen(accepted -> {
                        if (accepted) {
                            Util.m_137581_().m_137648_(uri);
                        }
                        Minecraft.m_91087_().m_91152_(curScreen);
                    }, clickEvent.m_130623_(), false));
                    return true;
                }
                catch (URISyntaxException e) {
                    this.errorToPlayer("Can't open url for %s (%s)", clickEvent.m_130623_(), e.getMessage());
                    return true;
                }
            }
            return false;
        }

        private void errorToPlayer(String msg, Object ... args) {
            QuestScreen.displayError((Component)Component.m_237113_((String)String.format(msg, args)).m_130940_(ChatFormatting.RED));
        }

        public boolean mouseDoubleClicked(MouseButton button) {
            if (this.isMouseOver() && this.canEdit) {
                this.editCallback.accept(false);
                return true;
            }
            return false;
        }

        @Nullable
        public CursorType getCursor() {
            return this.canEdit ? CursorType.IBEAM : null;
        }

        public void addMouseOverText(TooltipList list) {
            if (!this.isMouseOver()) {
                return;
            }
            super.addMouseOverText(list);
            Style style = this.getComponentStyleAt(ViewQuestPanel.this.questScreen.getTheme(), this.getMouseX(), this.getMouseY());
            if (style != null && style.m_131186_() != null) {
                TooltipFlag.Default flag;
                HoverEvent hoverevent = style.m_131186_();
                HoverEvent.ItemStackInfo stackInfo = (HoverEvent.ItemStackInfo)hoverevent.m_130823_(HoverEvent.Action.f_130832_);
                Minecraft mc = Minecraft.m_91087_();
                TooltipFlag.Default default_ = flag = mc.f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
                if (stackInfo != null) {
                    stackInfo.m_130898_().m_41651_((Player)mc.f_91074_, (TooltipFlag)flag).forEach(arg_0 -> ((TooltipList)list).add(arg_0));
                } else {
                    HoverEvent.EntityTooltipInfo entityInfo = (HoverEvent.EntityTooltipInfo)hoverevent.m_130823_(HoverEvent.Action.f_130833_);
                    if (entityInfo != null) {
                        if (flag.m_7050_()) {
                            entityInfo.m_130884_().forEach(arg_0 -> ((TooltipList)list).add(arg_0));
                        }
                    } else {
                        Component component = (Component)hoverevent.m_130823_(HoverEvent.Action.f_130831_);
                        if (component != null) {
                            list.add(component);
                        }
                    }
                }
            }
        }
    }

    private class CloseViewQuestButton
    extends AbstractPanelButton {
        private CloseViewQuestButton() {
            super((Component)Component.m_237115_((String)"gui.close"), (Icon)ThemeProperties.CLOSE_ICON.get(ViewQuestPanel.this.quest));
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            ViewQuestPanel.this.questScreen.closeQuest();
        }
    }

    private class PinViewQuestButton
    extends AbstractPanelButton {
        private PinViewQuestButton() {
            super((Component)Component.m_237115_((String)(ClientQuestFile.isQuestPinned(ViewQuestPanel.this.quest.id) ? "ftbquests.gui.unpin" : "ftbquests.gui.pin")), ClientQuestFile.isQuestPinned(ViewQuestPanel.this.quest.id) ? (Icon)ThemeProperties.PIN_ICON_ON.get() : (Icon)ThemeProperties.PIN_ICON_OFF.get());
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            new TogglePinnedMessage(ViewQuestPanel.this.quest.id).sendToServer();
        }
    }

    private class GotoLinkedQuestButton
    extends AbstractPanelButton {
        public GotoLinkedQuestButton() {
            super((Component)Component.m_237110_((String)"ftbquests.gui.goto_linked_quest", (Object[])new Object[]{ViewQuestPanel.this.quest.chapter.getTitle().m_6881_().m_130940_(ChatFormatting.YELLOW)}), (Icon)ThemeProperties.LINK_ICON.get());
        }

        public void onClicked(MouseButton button) {
            double qx = ViewQuestPanel.this.quest.x + 0.5;
            double qy = ViewQuestPanel.this.quest.y + 0.5;
            ViewQuestPanel.this.questScreen.selectChapter(ViewQuestPanel.this.quest.chapter);
            ViewQuestPanel.this.questScreen.questPanel.scrollTo(qx, qy);
        }
    }

    private class ViewQuestLinksButton
    extends AbstractPanelButton {
        private final List<QuestLink> links;

        public ViewQuestLinksButton(Collection<QuestLink> links) {
            super((Component)Component.m_237115_((String)"ftbquests.gui.view_quest_links"), (Icon)ThemeProperties.LINK_ICON.get());
            this.links = List.copyOf(links);
        }

        public void onClicked(MouseButton button) {
            ArrayList items = new ArrayList();
            for (QuestLink link : this.links) {
                link.getQuest().ifPresent(quest -> {
                    MutableComponent title = quest.getTitle().m_6881_().m_130946_(": ").m_7220_((Component)link.getChapter().getTitle().m_6881_().m_130940_(ChatFormatting.YELLOW));
                    items.add(new ContextMenuItem((Component)title, quest.getIcon(), () -> this.gotoLink(link)));
                });
            }
            if (!items.isEmpty()) {
                ViewQuestPanel.this.questScreen.openContextMenu(items);
            }
        }

        private void gotoLink(QuestLink link) {
            ViewQuestPanel.this.questScreen.closeQuest();
            ViewQuestPanel.this.questScreen.selectChapter(link.getChapter());
            ViewQuestPanel.this.questScreen.questPanel.scrollTo(link.getX() + 0.5, link.getX() + 0.5);
        }

        public boolean isEnabled() {
            return !this.links.isEmpty();
        }

        public boolean shouldDraw() {
            return !this.links.isEmpty();
        }
    }

    private abstract class AbstractPanelButton
    extends SimpleTextButton {
        public AbstractPanelButton(Component txt, Icon icon) {
            super((Panel)ViewQuestPanel.this, txt, icon);
        }

        public void draw(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
            this.drawIcon(matrixStack, theme, x + 1, y + 1, w - 2, h - 2);
        }
    }
}

